init python:

    # Add to the main menu.
    config.main_menu.insert(3, ("Music Room", "music_room", "True"))

    def set_playing_(track):
        store.playing = track
        return True

    set_playing = renpy.curry(set_playing_)

    # Call this with a button name and a track to define a music
    # button.
    def music_button(name, track):

        if store.playing == track:
            role = "selected_"
        else:
            role = ""

        if not renpy.seen_audio(track):
            name = "???"
            clicked = None
        else:
            clicked = set_playing(track)


        ui.textbutton(
            name,
            clicked=clicked,
            role=role,
            size_group="music")

label music_room:

    scene sky with dissolve

    python:
        _game_menu_screen = None

        # The default track of music.
        playing = "midnastheme.ogg"

label music_room_loop:

    # Play the playing music, if it changed.
    python:
        renpy.music.play(playing, if_changed=True, fadeout=1)

        # Display the various music buttons.
        ui.vbox(xalign=0.5, ypos=100)
        music_button("Midna's Theme", "midnastheme.ogg")
        music_button("Sacred Grove", "sacredgrove.ogg")
        music_button("Hyrule Field (night)", "hyrulefieldnight.ogg")
        music_button("Lake Hylia", "lakehylia.ogg")
        music_button("Star Game Room", "stargameroom.ogg")
        ui.close()

        # This is how we return to the main menu.
        ui.textbutton(
            "Return",
            clicked=ui.returns(False),
            xalign=0.5,
            ypos=450,
            size_group="music")

    if ui.interact():
        jump music_room_loop
    else:
        return
